-- --------------------------------------------------------------------------
-- Copyright  2008 PlayFirst, Inc. All Rights Reserved.
--
-- This material is the confidential trade secret and proprietary
-- information of PlayFirst, Inc. It may not be reproduced, used, disclosed,
-- sold or transferred without the prior written consent of PlayFirst, Inc. 
-- All rights reserved.
-- --------------------------------------------------------------------------
require( "scripts/style.lua" );


TitleFont = {
  standardFont,
  70,
  BlackColor
};

MedalFont = {
  standardFont,
  20,
  BlackColor
};





medalPosition = nil;
medalPosition = 
{	
	medalXOffset = 25,
	medalYOffset = 25,


	medal1X = 98, 
	medal1Y = 73,
	medal2X = 218, 
	medal2Y = 73,
	medal3X = 337, 
	medal3Y = 73,
	medal4X = 457, 
	medal4Y = 73,
	medal5X = 574, 
	medal5Y = 73,
	
	
	
	medal6X = 107, 
	medal6Y = 217,
	medal7X = 223, 
	medal7Y = 217,
	medal8X = 337, 
	medal8Y = 217,
	medal9X = 451, 
	medal9Y = 217,
	medal10X = 568, 
	medal10Y = 203,
	
	
	
	medal11X = 564, 
	medal11Y = 326,
	medal12X = 225, 
	medal12Y = 326,
	medal13X = 449, 
	medal13Y = 326,
	medal14X = 336, 
	medal14Y = 326,
	medal15X = 110, 
	medal15Y = 326,
}










function UpdateSubmit()
	local localHS = IsEnabled(kHiscoreLocalOnly);
	local anonHS = IsEnabled(kHiscoreAnonymous);
	local fullHS = (not localHS) and (not anonHS);
	EnableWindow('submit', fullHS and NumMedalsToSubmit() > 0);
end


function DoMedal(medalName, posX, posY, descrip)

	numMedals = GetNbMedals();
	--medalimage = "images/hiscore/medals/award_none_0001";
	for i=0,numMedals-1 do
		if (GetPFMedalName(i) == medalName) then
			if (HasEarnedMedal(i)) then
				medalimage=GetMedalFilename(i);
			end
			break;
		end
	end

	
	return Group
	{
		Bitmap
		{
			image=medalimage,
			x = posX,
			y = posY,
			
			name=medalName,
			
			scale = 0.85,
			RolloverWindow
			{
				name=medalName,
				x=0,y=0,w=kMax,h=kMax,
				activate = 'medaldescript',
				text = descrip;
				CreateMedalSprite(medalimage, posX, posY),
				
			};
		};
	};
end


	
function MakeMedals()

	width = 125;
	XOffset = 0;
	local windows = {};
	
	XOffset = 100;
	table.insert(windows, DoMedal(GetPFMedalName(0), XOffset + 0*width, 75, GetString('ui.trophies.descrip.venue1'))); --Complete 1st venu
	table.insert(windows, DoMedal(GetPFMedalName(1), XOffset + 1*width, 75, GetString('ui.trophies.descrip.venue2'))); --Complete 2nd venu
	table.insert(windows, DoMedal(GetPFMedalName(2), XOffset + 2*width, 75, GetString('ui.trophies.descrip.venue3'))); --Complete 3rd venu
	table.insert(windows, DoMedal(GetPFMedalName(3), XOffset + 3*width, 75, GetString('ui.trophies.descrip.venue4'))); --Complete 4th venu
	table.insert(windows, DoMedal(GetPFMedalName(4), XOffset + 4*width, 75, GetString('ui.trophies.descrip.venue5'))); --Complete 5th venu
	
	--XOffset = 0;
	table.insert(windows, DoMedal(GetPFMedalName(5), XOffset + 0*width, 210, GetString('ui.trophies.descrip.allexpert'))); --All expert Goal
	table.insert(windows, DoMedal(GetPFMedalName(6), XOffset + 1*width, 210, GetString('ui.trophies.descrip50'))); --50 customer fit
	table.insert(windows, DoMedal(GetPFMedalName(7), XOffset + 2*width, 210, GetString('ui.trophies.descrip200'))); --200
	table.insert(windows, DoMedal(GetPFMedalName(8), XOffset + 3*width, 210, GetString('ui.trophies.descrip500'))); --500
	table.insert(windows, DoMedal(GetPFMedalName(9), XOffset + 4*width, 210, GetString('ui.trophies.descrip1000'))); --1000
	
	--Offline
	--XOffset = 0;
	table.insert(windows, DoMedal(GetPFMedalName(10), XOffset + 0*width, 400, GetString('ui.trophies.descrip.upgrade'))); --Home Decorator
	table.insert(windows, DoMedal(GetPFMedalName(11), XOffset + 1*width, 400, GetString('ui.trophies.descrip.water'))); --Hydratation
	table.insert(windows, DoMedal(GetPFMedalName(12), XOffset + 2*width, 400, GetString('ui.trophies.descrip.snack'))); --Healthy diet
	table.insert(windows, DoMedal(GetPFMedalName(13), XOffset + 3*width, 400, GetString('ui.trophies.descrip.juice'))); --Zesty Juice
	table.insert(windows, DoMedal(GetPFMedalName(14), XOffset + 4*width, 400, GetString('ui.trophies.descrip.towel'))); --Laundry Day 

	return Group(windows);
end


MakeDialog
{
	
	name="TMedalWindow",

	
	Bitmap
	{
		--x = 0, y = 0, w = kMax, h = kMax,
		image="images/hiscore/trophy/bg-trophies",
		
		medalWindow
		{		
			-- Name the modal dialog
			name="medalwindow",
			x = 0, y = 0, w = kMax, h = kMax,
			
			--MakeMedals(),
			
			Text
			{
				font = MedalFont,
				x = 0,
				y = 360,
				h = 100,
				w = kMax,
				flags = kHAlignCenter + kVAlignTop,
				name = 'medaldescript',
			};
			SetStyle(FitnessButtonStyleTittleXLBlue),
			SBButton
			{
				icon="images/ui/buttons/icon/iconsubmit",	
				x=kMax - 220,
				y=kMax - 155,
				name="submit",
				label="submit",
				command =
					function()
						vars = loadstring(GetSetupString(true));
						vars();
						val = DoModal("scripts/medalsubmit.lua");
						if (val == 'success') then
							DisplayDialog {
								"scripts/ok.lua",
								body ="medalsuccess",
								title = ""
							};
						end
						UpdateSubmit();
					end
			};

			SetStyle(FitnessButtonStyleTittleSmallBlue2),
			SBButton
			{
				x=125,
				y=kMax-120,
				name="back",
				icon="assets/images/ui/buttons/icon/iconback",
				flags = kHAlignCenter + kVAlignCenter,
				label="common.back.label",
				command =
					function()
						SetMustShowMedalScreen(false);
						PopModal("TMedalWindow");
					end
			};
		},
	},
}

UpdateSubmit();